// MSVC Viewer.h : main header file for the MSVC VIEWER application
//

#if !defined(AFX_MSVCVIEWER_H__856F07EA_B6C5_11D2_A474_0040C711066C__INCLUDED_)
#define AFX_MSVCVIEWER_H__856F07EA_B6C5_11D2_A474_0040C711066C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols
#include "DicomServerSink.h"
#include "MSVC ViewerDoc.h"
#include "QROptions.h"	// Added by ClassView
#include "PrintOptions.h"	// Added by ClassView
#include "QRDialog.h"

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerApp:
// See MSVC Viewer.cpp for the implementation of this class
//

class CMSVCViewerApp : public CWinApp
{
public:
	CQRDialog qr;
	CQROptions options;
	CPrintOptions printOptions;
	CMSVCViewerDoc *  AddNewImage(IDicomImagePtr image);
	IDicomServerPtr Server;
	CDicomServerSink Sink;
	DWORD SinkCookie;
	CMSVCViewerApp();
	IDicomGlobalPtr global;
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMSVCViewerApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation
	COleTemplateServer m_server;
		// Server object for document creation

	//{{AFX_MSG(CMSVCViewerApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFileNew();
	afx_msg void OnEditPaste();
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnFileImport();
	afx_msg void OnRemoteVerify();
	afx_msg void OnRemoteQueryoptions();
	afx_msg void OnRemoteQueryretrieve();
	afx_msg void OnLoggingEnablelogging();
	afx_msg void OnLoggingLogdirectory();
	afx_msg void OnUpdateLoggingEnablelogging(CCmdUI* pCmdUI);
	afx_msg void OnLoggingLogginglevel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MSVCVIEWER_H__856F07EA_B6C5_11D2_A474_0040C711066C__INCLUDED_)
